/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.system.action;

import jp.mosp.common.MosPAction;
import jp.mosp.common.dao.CmCodeDao;
import jp.mosp.common.dto.CmCodeDto;


import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.system.vo.CmCodeCardVo;

public class CmCodeCardAction extends MosPAction {

	// R}h
	private static final String CMD_CODE_CARD_SHOW   = "S2005";	// \(ǉ)
	private static final String CMD_CODE_CARD_SELECT = "S2006";	// \(I)
	private static final String CMD_CODE_CARD_INSERT = "S2007";	// o^
	private static final String CMD_CODE_CARD_UPDATE = "S2008";	// XV

	/**
	 * RXgN^
	 */
	public CmCodeCardAction() {
		super();
	}

	/**
	 * ANV
	 */
	public void action() throws Exception {
		// DBRlNV擾
		getConnection();
		// SYSTEMmF
		confirmSystemAuth();
		// VO̎擾yѐݒ
		CmCodeCardVo vo = new CmCodeCardVo();
		vo.initVo(cfg, msg, cmd, aspUser, user);
		vo.setParams(request);
		// VOyуtH[hURL̐ݒ
		setVo(vo);
		setUrl(vo.getRetUrl());
		// DBRlNV擾
		getConnection();
		// DAȌ
		CmCodeDao dao;
		dao = new CmCodeDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// R[h敪v_EXg쐬
		vo.aryPltTId = getCodeArray();
		// DTO̎擾
		CmCodeDto dto;
		Object obj = session.getAttribute(MospConst.ATT_DTO);
		dto = obj instanceof CmCodeDto ? (CmCodeDto)obj : null;
		// R}h̏
		if (cmd.equals(CMD_CODE_CARD_SHOW)) {
			// \(VK)
			vo.setPltTId("");
			vo.setTxtTCode("");
			vo.setTxtTName("");
			vo.setTxtIndex("");
			vo.setPltDelete("");
			vo.setMode(CmCodeCardVo.MODE_INSERT);		
		} else if (cmd.equals(CMD_CODE_CARD_SELECT)) {
			// \(L[ŏ)
			// f[^̎擾
			dto = dao.findForKey(key1, key2);
			chkExist(dto);
			// VOɏZbg
			vo.setFields(dto);
			vo.setMode(CmCodeCardVo.MODE_UPDATE);
			// ZbVDTOZbg
			session.setAttribute(MospConst.ATT_DTO, dto);
		} else if (cmd.equals(CMD_CODE_CARD_INSERT)) {
			// VKo^
			dto = insert(vo);
			// ZbVDTOZbg
			session.setAttribute(MospConst.ATT_DTO, dto);
		} else if (cmd.equals(CMD_CODE_CARD_UPDATE)) {	
			// XV
			dto = update(vo, dto);
			// ZbVDTOZbg
			session.setAttribute(MospConst.ATT_DTO, dto);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}

	/**
	 * f[^}
	 * @param vo ΏVO
	 * @return f[^}ΏDTO
	 * @throws Exception
	 */
	private CmCodeDto insert(CmCodeCardVo vo) throws Exception {
		vo.setPltDelete(String.valueOf(MospConst.DELETE_FLAG_OFF));
		// p[^̑ÓmF
		vo.validate(true);
		// RlNV̎擾yDAȌ
		getConnection();
		CmCodeDao dao = new CmCodeDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// ݃`FbN
		chkDuplicate(dao.findForKey(vo.getPltTId(), vo.getTxtTCode()), vo);
		// DTȌ
		CmCodeDto dto = new CmCodeDto();
		vo.setDtoFields(dto);
		// f[^̑}
		dao.insert(dto);
		// DTO̍Ď擾
		dto = dao.findForKey(dto.getTId(), dto.getTCode());
		// R~bg
		commit();
		// [hݒ
		vo.setMode(CmCodeCardVo.MODE_UPDATE);
		// bZ[Wݒ
		vo.setMessage(MospUtility.getMessage(msg, MospConst.MSG_INSERT, ""));
		return dto;
	}

	/**
	 * f[^XV
	 * @param vo ΏVO
	 * @param dto ΏDTO
	 * @return f[^}ΏDTO
	 * @throws Exception
	 */
	private CmCodeDto update(CmCodeCardVo vo, CmCodeDto dto) throws Exception {
		// R[h敪擾
		vo.setPltTId(dto.getTId());
		// p[^̑ÓmF
		vo.validate(false);
		// RlNV̎擾yDAȌ
		getConnection();
		CmCodeDao dao = new CmCodeDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// rmF
		chkExclusive(dto, dao.findForUpdate(vo.getPltTId(), vo.getTxtTCode()), vo);
		// DTȌ
		vo.setDtoFields(dto);
		// f[^̍XV
		dao.update(dto);
		// DTO̍Ď擾
		CmCodeDto retDto = dao.findForKey(dto.getTId(), dto.getTCode());
		chkUpdate(retDto);
		// R~bg
		commit();
		// [hݒ
		vo.setMode(CmCodeCardVo.MODE_UPDATE);
		// bZ[Wݒ
		vo.setMessage(MospUtility.getMessage(msg, MospConst.MSG_UPDATE, ""));
		return retDto;
	}

}
